from flask import Flask, request, jsonify
from playwright.sync_api import sync_playwright
import os
import time

app = Flask(__name__)

APP_URL = os.environ.get('APP_URL', 'http://nginx')
FLAG = os.environ.get('FLAG', 'INTIGRITI{test_flag}')
ADMIN_USERNAME = os.environ.get('ADMIN_USERNAME', 'admin')
ADMIN_PASSWORD = os.environ.get('ADMIN_PASSWORD', 'hunter2')

BOT_PREVIEW_TOKEN = "pk_019c653a34c0718d8afaa7278f0f20ce"

def visit_post(post_id):
    try:
        with sync_playwright() as p:
            browser = p.chromium.launch(
                headless=True,
                args=['--no-sandbox', '--disable-dev-shm-usage']
            )
            
            context = browser.new_context(
                viewport={'width': 1920, 'height': 1080},
                user_agent='Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 Chrome/120.0.0.0 Safari/537.36 InkDropBot/2.0'
            )
            
            context.set_extra_http_headers({
                'X-Preview-Token': BOT_PREVIEW_TOKEN
            })
            
            context.add_cookies([{
                'name': 'flag',
                'value': FLAG,
                'domain': 'nginx',
                'path': '/',
                'httpOnly': False,
                'secure': False,
                'sameSite': 'Lax'
            }])
            
            page = context.new_page()
            
            page.goto(f'{APP_URL}/login', timeout=10000)
            page.fill('input[name="username"]', ADMIN_USERNAME)
            page.fill('input[name="password"]', ADMIN_PASSWORD)
            page.click('button[type="submit"]')
            page.wait_for_load_state('networkidle')
            
            url = f'{APP_URL}/post/{post_id}'
            page.goto(url, timeout=15000, wait_until='networkidle')
            
            time.sleep(5)
            
            browser.close()
            return True
            
    except Exception as e:
        print(f"[Bot] Error: {e}", flush=True)
        return False

@app.route('/visit', methods=['POST'])
def handle_visit():
    data = request.get_json()
    
    if not data or 'post_id' not in data:
        return jsonify({'error': 'post_id required'}), 400
    
    post_id = data['post_id']
    
    success = visit_post(post_id)
    return jsonify({'status': 'visited' if success else 'failed'})

@app.route('/health')
def health():
    return 'OK'

if __name__ == '__main__':
    import logging
    log = logging.getLogger('werkzeug')
    log.setLevel(logging.ERROR)
    print("[Bot] Bot service ready", flush=True)
    app.run(host='0.0.0.0', port=8090)
